import os
import numpy as np
import openmc
import openmc.stats
import nuscale.surfaces
import nuscale.materials
from nuscale.core import core_geometry
from nuscale.surfaces import surfs
from nuscale.tallies import mesh_tallies
seed = 1
#openmc.config['cross_sections'] = '/home/sgaezald/xsdata/endfb-vii.1-hdf5 (Serpent)/cross_sections.xml'
# Remove previous .xml files if they exist
for f in os.listdir('.'):
    if f.endswith('.xml'):
        os.remove(os.path.join('.', f))

pitch = nuscale.surfaces.pin_cell_pitch
assembly_pitch = nuscale.surfaces.assembly_pitch
bottom_fuel = surfs['fuel bottom'].z0
top_fuel = surfs['fuel top'].z0

geometry = core_geometry(control_rods='single_rod')

# Construct uniform initial source distribution over fissionable zones
lower_left = geometry.bounding_box[0]
upper_right = geometry.bounding_box[1]
source = openmc.source.Source(space=openmc.stats.Box(lower_left, upper_right))
source.space.only_fissionable = True

os.makedirs('./1single_rod', exist_ok=True)

settings = openmc.Settings()
settings.batches = 2700
settings.inactive = 200
settings.particles = 1000000
settings.output = {'tallies': False,
                   'path': '1single_rod'}
settings.source = source
settings.seed = seed
settings.sourcepoint = {'write': False}
settings.temperature = {
    'default': 900,
    'method': 'interpolation',
    'range': (300.0, 1500.0),
}

materials = openmc.Materials(nuscale.materials.mats.values())

tallies = mesh_tallies(fa_radial=True, pin_radial=True, axial=True)

model = openmc.Model()
model.settings = settings
model.geometry = geometry
model.materials = materials
model.tallies = tallies

model.run(threads=40)